/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.io.FileFinder;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class MultipleClassLoader
extends ClassLoader {
    private String name = null;
    private ArrayList loaders = new ArrayList();
    private Hashtable cache = new Hashtable();
    private ClassFinder finder = new ClassFinder();
    private URLLoader ucl = new URLLoader();

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "multipleClassLoader";
        }
        return this.name;
    }

    public void addClassloader(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        Logger.debug(this.getName() + ": adding class loader " + loader.getClass().getName());
        this.loaders.add(loader);
        if (loader instanceof MultipleClassLoader) {
            this.finder.addFinder(((MultipleClassLoader)loader).getClassFinder());
        }
    }

    public void add(URL url) {
        this.ucl.addURL(url);
    }

    public URL[] getURLs() {
        return this.ucl.getURLs();
    }

    public File[] getFiles() {
        ArrayList<File> l = new ArrayList<File>();
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            try {
                File f = new File(urls[i].getFile());
                if (!f.exists()) continue;
                l.add(f);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l.toArray(new File[l.size()]);
    }

    public void add(File file) throws MalformedURLException {
        this.add(file.toURI().toURL());
    }

    public File[] addJars(File directory, String[] extensions) throws MalformedURLException {
        FileFinder finder = new FileFinder(directory);
        for (int i = 0; i < extensions.length; ++i) {
            finder.extension(extensions[i]);
        }
        File[] jars = finder.findRecursive();
        if (jars == null || jars.length < 1) {
            return null;
        }
        for (int i = 0; i < jars.length; ++i) {
            Logger.debug(this.getName() + ": adding file " + jars[i].getAbsolutePath());
            this.add(jars[i].toURI().toURL());
        }
        return jars;
    }

    public File[] addJars(File directory) throws MalformedURLException {
        return this.addJars(directory, new String[]{"jar", "zip"});
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.ucl.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.ucl.getResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = this.ucl.getResources(name);
        if (urls != null && urls.hasMoreElements()) {
            return urls;
        }
        return super.getResources(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.load(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public Class load(String className) throws ClassNotFoundException, LinkageError {
        Class c = (Class)this.cache.get(className);
        if (c != null) {
            return c;
        }
        LinkageError error = null;
        try {
            return this.findVia(this.ucl, className);
        }
        catch (LinkageError r) {
            error = r;
        }
        catch (ClassNotFoundException r) {
            // empty catch block
        }
        ClassLoader l = null;
        for (int i = 0; i < this.loaders.size(); ++i) {
            try {
                l = (ClassLoader)this.loaders.get(i);
                return this.findVia(l, className);
            }
            catch (LinkageError r) {
                error = r;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (error != null) {
            throw error;
        }
        throw new ClassNotFoundException(this.getName() + ": class not found: " + className);
    }

    private Class findVia(ClassLoader loader, String className) throws ClassNotFoundException {
        Class<?> c = loader.loadClass(className);
        if (this.cache.put(className, c) == null) {
            if (loader instanceof MultipleClassLoader) {
                ((MultipleClassLoader)loader).finder.addClass(c);
            } else {
                this.finder.addClass(c);
            }
        }
        return c;
    }

    public ClassFinder getClassFinder() {
        return this.finder;
    }

    public String toString() {
        return this.getName();
    }

    private class URLLoader
    extends URLClassLoader {
        public URLLoader() {
            super(new URL[0], MultipleClassLoader.this.getParent());
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }
}

